# 🛡️ DBAOps Sentinel API Documentation

## Base URL
```
http://localhost:3000/api
```

## Authentication
*Phase 2 - JWT tokens will be required*

---

## Endpoints

### Health Check
```
GET /api/health
```
Returns API and database connection status.

---

### Dashboard

#### Overview
```
GET /api/dashboard/overview
```
Returns aggregated stats for the command center.

**Response:**
```json
{
  "servers": 7,
  "databases": 10,
  "activeAlerts": 2,
  "autoHealed": 47,
  "securityScore": 85,
  "complianceScore": 100
}
```

---

### Servers

#### List All Servers
```
GET /api/servers
```

#### Get Server Details
```
GET /api/servers/:id
```

---

### Databases

#### List All Databases
```
GET /api/databases
```

---

### Alerts

#### List Alerts
```
GET /api/alerts
GET /api/alerts?status=Open,Acknowledged
```

#### Acknowledge Alert
```
POST /api/alerts/:id/acknowledge
Body: { "user": "username" }
```

#### Heal Alert (Sentinel)
```
POST /api/alerts/:id/heal
Body: { "user": "Sentinel" }
```

---

### Health Metrics

#### Current Health
```
GET /api/metrics/health
```

#### Metric History
```
GET /api/metrics/history/:metric
GET /api/metrics/history/cpu?hours=24
```
Metrics: cpu, memory, disk, network, health

---

### Compliance

#### All Frameworks
```
GET /api/compliance
```

#### Framework Details
```
GET /api/compliance/:framework
GET /api/compliance/CJIS
```

---

### Security

#### Security Overview
```
GET /api/security/overview
```

---

### Sentinel

#### Healing Rules
```
GET /api/sentinel/rules
```

#### Activity Log
```
GET /api/sentinel/activity
GET /api/sentinel/activity?limit=50
```

#### Run Scan
```
POST /api/sentinel/scan
```

---

### Backups

#### Backup Status
```
GET /api/backups/status
```

#### Run Backup
```
POST /api/backups/run
Body: { "serverId": 1, "databaseId": 5, "type": "Full" }
```

---

### Licensing

#### Current License
```
GET /api/license
```

#### Industry Access
```
GET /api/license/industries
```

---

### Reports

#### Generate Report
```
POST /api/reports/generate
Body: { "reportType": "executive", "format": "PDF" }
```

---

### Discovery

#### Run Discovery
```
POST /api/discovery/scan
Body: { "method": "network", "target": "192.168.1.0/24" }
```

---

## Error Responses
```json
{
  "error": "Error message",
  "message": "Detailed description"
}
```

## Status Codes
- 200: Success
- 400: Bad Request
- 401: Unauthorized
- 404: Not Found
- 500: Server Error
