-- ============================================================
-- DBAOps: Onboarding & Configuration Wizard Schema
-- ============================================================
IF NOT EXISTS (SELECT 1 FROM sys.schemas WHERE name = 'setup')
    EXEC('CREATE SCHEMA setup');
GO

-- Installation/Setup Tracking
CREATE TABLE setup.InstallationConfig (
    ConfigID INT IDENTITY(1,1) PRIMARY KEY,
    InstallationID UNIQUEIDENTIFIER DEFAULT NEWID(),
    InstallDate DATETIME2 DEFAULT GETDATE(),
    ProductVersion NVARCHAR(20) NOT NULL,
    LicenseKey NVARCHAR(100),
    LicenseTier NVARCHAR(50),
    
    -- Environment Type
    EnvironmentType NVARCHAR(50), -- OnPremise, Hybrid, CloudOnly, AirGapped
    DeploymentMode NVARCHAR(50), -- SingleServer, HA, Distributed
    
    -- Scope Definition
    TargetOUs NVARCHAR(MAX), -- JSON array of AD OUs
    TargetSubnets NVARCHAR(MAX), -- JSON array of IP ranges
    TargetSubscriptions NVARCHAR(MAX), -- JSON array of Azure subscriptions
    TargetResourceGroups NVARCHAR(MAX),
    TargetVCenters NVARCHAR(MAX),
    TargetKubernetesNamespaces NVARCHAR(MAX),
    
    -- Connectivity
    ProxyServer NVARCHAR(200),
    ProxyPort INT,
    ProxyAuthRequired BIT DEFAULT 0,
    
    -- Setup Status
    SetupPhase NVARCHAR(50) DEFAULT 'NotStarted', -- NotStarted, InProgress, Completed, Failed
    SetupProgress INT DEFAULT 0,
    LastValidation DATETIME2,
    ValidationStatus NVARCHAR(MAX), -- JSON validation results
    
    -- Admin
    ConfiguredBy NVARCHAR(128),
    Notes NVARCHAR(MAX)
);

-- Setup Wizard Steps
CREATE TABLE setup.WizardSteps (
    StepID INT IDENTITY(1,1) PRIMARY KEY,
    StepOrder INT NOT NULL,
    StepName NVARCHAR(100) NOT NULL,
    StepDescription NVARCHAR(500),
    StepCategory NVARCHAR(50), -- Environment, Discovery, Identity, Connectivity, Validation
    IsRequired BIT DEFAULT 1,
    ValidationScript NVARCHAR(MAX),
    Status NVARCHAR(20) DEFAULT 'Pending', -- Pending, InProgress, Completed, Skipped, Failed
    CompletedAt DATETIME2,
    ErrorMessage NVARCHAR(MAX)
);

-- Pre-populate wizard steps
INSERT INTO setup.WizardSteps (StepOrder, StepName, StepDescription, StepCategory, IsRequired)
VALUES
(1, 'Welcome & License', 'Enter license key and accept terms', 'Setup', 1),
(2, 'Environment Type', 'Select deployment environment type', 'Environment', 1),
(3, 'Repository Database', 'Configure repository database connection', 'Environment', 1),
(4, 'Discovery Scope', 'Define target servers, OUs, subscriptions', 'Discovery', 1),
(5, 'Identity Provider', 'Configure authentication (AD/Entra/SAML)', 'Identity', 1),
(6, 'Service Account', 'Configure gMSA or service account', 'Identity', 1),
(7, 'Network Connectivity', 'Test firewall, DNS, proxy settings', 'Connectivity', 1),
(8, 'Secret Store', 'Configure credential vault integration', 'Security', 1),
(9, 'Initial Discovery', 'Run first discovery scan', 'Discovery', 1),
(10, 'Validation', 'Validate all connections and permissions', 'Validation', 1),
(11, 'Alert Configuration', 'Set up notification channels', 'Configuration', 0),
(12, 'Complete Setup', 'Finalize and start monitoring', 'Setup', 1);

-- Connectivity Test Results
CREATE TABLE setup.ConnectivityTests (
    TestID INT IDENTITY(1,1) PRIMARY KEY,
    TestTimestamp DATETIME2 DEFAULT GETDATE(),
    TestType NVARCHAR(50), -- DNS, Firewall, TLS, NTP, Proxy, API
    TargetHost NVARCHAR(256),
    TargetPort INT,
    Protocol NVARCHAR(20),
    TestResult NVARCHAR(20), -- Success, Failed, Timeout, Blocked
    ResponseTimeMs INT,
    ErrorDetails NVARCHAR(MAX),
    Recommendation NVARCHAR(500)
);

PRINT '✅ Onboarding & Configuration Wizard Schema Created';
