#Requires -RunAsAdministrator
param(
    [string]$InstallPath = "C:\Program Files\DBAOps\Sentinel",
    [switch]$KeepData,
    [switch]$Silent
)

if (-not $Silent) {
    Write-Host ""
    Write-Host "  DBAOps Sentinel Uninstaller" -ForegroundColor Cyan
    Write-Host ""
    $confirm = Read-Host "  Uninstall DBAOps Sentinel? (y/N)"
    if ($confirm -ne "y") { Write-Host "  Cancelled."; exit 0 }
}

Write-Host "  [1/5] Stopping services..." -ForegroundColor White
Stop-ScheduledTask -TaskName "DBAOps Sentinel Agent" -ErrorAction SilentlyContinue
Unregister-ScheduledTask -TaskName "DBAOps Sentinel Agent" -Confirm:$false -ErrorAction SilentlyContinue
Write-Host "        Done" -ForegroundColor Green

Write-Host "  [2/5] Removing environment variables..." -ForegroundColor White
[Environment]::SetEnvironmentVariable("SENTINEL_HOME", $null, "Machine")
[Environment]::SetEnvironmentVariable("SENTINEL_CONFIG", $null, "Machine")
$path = [Environment]::GetEnvironmentVariable("PATH", "Machine")
$newPath = ($path -split ";" | Where-Object { $_ -notlike "*Sentinel*" }) -join ";"
[Environment]::SetEnvironmentVariable("PATH", $newPath, "Machine")
Write-Host "        Done" -ForegroundColor Green

Write-Host "  [3/5] Removing registry entries..." -ForegroundColor White
Remove-Item "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\DBAOpsSentinel" -Force -ErrorAction SilentlyContinue
Write-Host "        Done" -ForegroundColor Green

Write-Host "  [4/5] Removing files..." -ForegroundColor White
if ($KeepData) {
    Get-ChildItem $InstallPath -Exclude "Data","Logs","Config" | Remove-Item -Recurse -Force -ErrorAction SilentlyContinue
    Write-Host "        Files removed (Data, Logs, Config preserved)" -ForegroundColor Green
} else {
    Remove-Item $InstallPath -Recurse -Force -ErrorAction SilentlyContinue
    Write-Host "        All files removed" -ForegroundColor Green
}

Write-Host "  [5/5] Cleanup..." -ForegroundColor White
Remove-Item "C:\Program Files\DBAOps" -Recurse -Force -ErrorAction SilentlyContinue
Write-Host "        Done" -ForegroundColor Green

Write-Host ""
Write-Host "  DBAOps Sentinel uninstalled successfully." -ForegroundColor Green
Write-Host "  Thank you for using Sentinel!" -ForegroundColor Cyan
Write-Host ""
